//Escape JavaScript at https://www.freeformatter.com/javascript-escape.html
/*
The following characters are reserved in JavaScript and must be properly escaped to be used in strings:
    Horizontal Tab is replaced with \t
    Vertical Tab is replaced with \v
    Nul char is replaced with \0
    Backspace is replaced with \b
    Form feed is replaced with \f
    Newline is replaced with \n
    Carriage return is replaced with \r
    Single quote is replaced with \'
    Double quote is replaced with \"
    Backslash is replaced with \\
*/
var samples = [
"if obj.firstRun() then\r\n\tobj.runInterval(-1, 0.1) --Run this every 0.1s\r\nend\r\n\r\nlocal openEd = obj.checkKey(\"q\")\r\n\r\nif openEd then \r\n\tobj.scriptEditor() --Pull up the script editor\r\nend\r\n\r\nlocal dBug = obj.checkKey(\"e\")\r\n\r\nif dBug then\r\n\tif obj.getDebugMode() then\r\n\t\tobj.setDebugMode(false) --Toggle debug mode\r\n\telse\r\n\t\tobj.setDebugMode(true)\r\n\tend\r\nend", 

"if obj.firstRun() then \r\n    player = -1\r\n    obj.runInterval(-1, 0.1)\r\n\tplayer = obj.tryStore(\"Player\")\r\nend\r\n\r\nif player > -1 then \r\n\r\n\t--We found them\r\n\tlocal pX = obj.getX(player)\r\n\tlocal pY = obj.getY(player)\r\n\tlocal pZ = obj.getZ(player)\r\n\t\r\n\t--Show the position above them\r\n\tobj.set3DText(\"Player position: \" .. pX .. \",\" .. pY .. \",\" .. pZ)\r\nend", 

"--Every 0.5 seconds, the timer under name \"newSeed\" will set the text above the object to a value between 0,10 (floating point), and it loops\r\n--Game logic could be stored this way, repeat calls to set an existing timer will replace it (and restart the countdown)\r\nobj.setTimer(\"newSeed\", 0.5, \"obj.set3DText(\\\"Number:\\\" .. obj.random(0,10))\", true)\r\n", 

"--Abusing the timer system, we can make a control to move along Z that runs every frame\r\nobj.setTimer(\"moveZ\", -1, \"if obj.checkKey(\\\"e\\\") then \\n obj.translateStored(\\\"0,0,1\\\", -1) \\n end\", true)\r\nobj.setTimer(\"moveZBack\", -1, \"if obj.checkKey(\\\"q\\\") then \\n obj.translateStored(\\\"0,0,-1\\\", -1) \\n end\", true)", 

"--On collision with player, or their VR hands, the object will say \"hey you touched me\"\r\nobj.setAction(\"touchMePlayer\", \"Player,VR_Hand_Left,VR_Hand_Right\", \"obj.set3DText(\\\"Hey you touched me!\\\")\")\r\n", 

"--Setup a frame count variable, then set script to repeat\r\nif obj.firstRun() then\r\n\tframeCount = 0\r\n\tobj.setLightColor(\"0,0,1,1\") --Solid blue\r\n\tobj.runInterval(-1, 0.1)\r\nend\r\n\t\t\t\t\r\nobj.setLightIntensity(300 * math.abs(math.sin(frameCount ))) --Oscillate intensity 0 - 300\r\n\r\nframeCount  = frameCount  + obj.getDT() --Increase frame count", 

"if obj.firstRun() then\r\n\r\n\tobj.pushState() --Store starting position\r\n\r\n\tqWasDown = false\r\n\teWasDown = false\r\n\t\r\n\tobj.runInterval(-1, 0.1)\r\n\t\r\nend\r\n\r\nobj.translateStored(\"0.1, 0, 0\") --Default moves us instead of stored\r\n\r\nqDown = obj.checkKey(\"q\")\r\neDown = obj.checkKey(\"e\")\r\n\r\nif eDown == false then\r\n\r\n\teWasDown = false\r\n\r\nend\r\n\r\nif qDown == false then\r\n\r\n\tqWasDown = false\r\n\r\nend\r\n\r\nif qDown == true and qWasDown == false then\r\n\r\n\tqWasDown = true\r\n\t\r\n\t--push state\r\n\tobj.pushState()\r\n\r\nend\r\n\r\nif eDown == true and eWasDown == false then\r\n\r\n\teWasDown = true\r\n\r\n\t--pop state\r\n\tobj.popState()\r\n\r\nend", 

"if obj.firstRun() then --First time running?\r\n\r\n\tobj.OpenHiddenWeb(\"http:\/\/www.google.ca\") --Any page will do\r\n\tobj.EvalJS(\"var a = 10;\", 0) --Run some JS without storing it\r\n\tobj.EvalJS(\"document.title + a\", 0, \"webResult\") --Run more JS and tell it where to store the result\r\n\tobj.runInterval(-1, 0.1) --Run this script every 0.1s\r\n\r\nend\r\n\r\nif obj.checkWebResult(\"webResult\") then --Wait until we have a result\r\n\r\n\tobj.set3DText(obj.getDictString(\"webResult\")) --Display the result\r\n\tobj.runInterval(-1,0.1,false) --Stop running\r\n\r\nend",

"--Create a simple object from the example.switch asset bundle in StreamingAssets\r\nobj.createAsset(\"example.switch\", \"switch\", 0, 0, 0)", 

"--Diagonal scroll texture\r\nif obj.firstRun() then\r\n\ttx = 0\r\n\tty = 0\r\n\tobj.runInterval(-1, 0.1)\r\nend\r\n\r\nobj.offsetTexture(tx, ty)\r\ntx = tx + obj.getDT()\r\nty = ty + obj.getDT()", 

"if obj.firstRun() then\r\n\tplayer = obj.tryStore(\"Player\")\r\n\t\r\n\tif player > -1 then\r\n\t\tobj.setParent(-1, player)\r\n\tend\r\n\t\r\n\tcamOn = true\r\n\tobj.runInterval(-1, 0.1)\r\nend\r\n\r\nif obj.checkKey(\"e\") then\r\n\tcamOn = not camOn\r\n\tobj.setCamEnabled(camOn)\r\nend", 

"function onClick(type)\r\n\r\n\t\tif type == 0 then\r\n\t\t\r\n\t\t\tobj.setGizmoTarget(-1) --Target self\r\n\t\t\tobj.moveGizmo() --Enable move gizmo\r\n\t\t\r\n\t\tend\r\n\t\r\n\t\tif type == 3 then\r\n\r\n\t\t\tobj.clearGizmoTarget() --Disable with right click on object\r\n\r\n\t\tend\r\n\t\t\r\n\tend", 

"local minRot = 0 --Min rotation Y\r\nlocal maxRot = 360 --Max rotation Y\r\nlocal actRot = obj.random(minRot, maxRot) --Get a random rotation\r\nobj.rotateStored(\"0,\" .. tostring(actRot) .. \",0\") --Rotate by this amount", 

"--Position this object to player, hide player, and voila a fake avatar!\r\nif obj.firstRun() then\r\n\tplayer = obj.tryStore(\"Player\")\r\n\t\r\n\tif player > -1 then\r\n\t\tobj.setParent(-1, player)\r\n\tend\r\n\r\n\tobj.moveStored(\"0,0,0\", -1, true)\r\n\t\r\n\tobj.setPlayerHidden(true)\r\nend", 

"--Simple two player controls, set player number, make sure there is an object in the scene with tag Alpha for player one, and Beta for player two\r\n--This script belongs on a camera object\r\n--It will only work if it finds the object it is looking for\r\nplayer = 1\r\nmoveSpd = 10\r\nrotSpd = 60\r\n\r\n--How to position the camera behind our object\r\ncamoffset = \"0, 1, -1\"\r\n\r\n--Player one controls\r\nfwdkey = \'w\'\r\nbackkey = \'s\'\r\nleftkey = \'a\'\r\nrightkey = \'d\'\r\n\r\nfindtag = \'Alpha\'\r\n\r\nif player == 1 then\r\n\t--This could easily be expanded to more players just by adding more checks for player number\r\n\t--Eg: top-left would be 0,0,0.5,0.5, top-right 0.5,0,0.5,0.5, bottom-left 0,0.5,0.5,0.5, bottom-right 0.5,0.5,0.5,0.5\r\n    obj.setCamViewPort(0, 0, 0.5, 1)\r\nelse\r\n    obj.setCamViewPort(0.5, 0, 0.5, 1)\r\n\t\r\n\t--Player two controls\r\n    fwdkey = \'i\'\r\n    backkey = \'k\'\r\n    leftkey = \'j\'\r\n    rightkey = \'l\'\r\n    \r\n    findtag = \'Beta\'\r\nend\r\n\r\nmyplayer = obj.tryStore(findtag)\r\n\r\n--Check if we have a player, then make ourselves attached to them\r\nif obj.notNull(myplayer) then\r\n    obj.setParent(-1, myplayer)\r\n    obj.moveStored(camoffset, -1, true)\r\n    \r\n\t--Found it! enable our camera and disable the player\r\n    obj.setCamEnabled(true)\r\n    obj.setPlayerEnabled(false)\r\n    obj.setPlayerHidden(true)\r\nend\r\n\r\nfunction onFrameTick(dt)\r\n    if obj.notNull(myplayer) then\r\n\r\n        --Get player input\r\n        local xIn = 0\r\n        local yIn = 0\r\n    \r\n        if obj.checkKey(fwdkey) then\r\n            yIn = moveSpd * dt\r\n        end\r\n    \r\n        if obj.checkKey(backkey) then\r\n            yIn = -1.0 * moveSpd * dt\r\n        end\r\n    \r\n        if obj.checkKey(leftkey) then\r\n            xIn = -1.0 * rotSpd * dt\r\n        end\r\n    \r\n        if obj.checkKey(rightkey) then\r\n            xIn = rotSpd * dt\r\n        end\r\n    \r\n        --Move and rotate\r\n        --Get the forward direction of the player object\r\n\t\tlocal fwd = obj.getForward(myplayer)\r\n\t\t\r\n\t\t--Break it into X,Y,Z values array, LUA starts at 1 not 0!\r\n        local components = obj.split(fwd, \',\')\r\n\t\t\r\n\t\t--Multiply each value by yIn\r\n        local newmove = components[1] * yIn .. \',\' .. components[2] * yIn .. \',\' .. components[3] * yIn\r\n\t\t--This could also be done with obj.scaleVector3(components[1], components[2], components[3], yIn)\r\n\t\t\r\n\t\t--Move by this offset\r\n        obj.translateStored(newmove, myplayer)\r\n        \r\n\t\t--Rotation is simple, we just rotate on the Y axis (Yaw)\r\n        local rot = \"0,\" .. xIn .. \",0\"\r\n        obj.rotateStored(rot, myplayer)\r\n    end\r\nend", 

"obj.set3DText(\"Say Hello\")\r\nobj.set3DTextColor(\"0,0,0,1\")\r\n\r\nfunction onClick(type)\r\n\t--0 for mouse, 1 for left hand VR trigger, 2 for right hand VR trigger, 3 for mouse right click, 4 for mouse middle click\r\n\tobj.set3DText(\"You Clicked Me With: \" .. type)\r\nend",

"--Simple path follower\r\nlocal Path = 0\r\nlocal Point = 0\r\nlocal Forward = true\r\nobj.followPath(Path, Point, Forward)\r\nobj.followerMoveSpd(0.1)",

"--Simple waypoint\r\nlocal Path = 0\r\nlocal Point = 0\r\nlocal Wait = 0\r\nobj.makeWaypoint(Path, Point, Wait)",

"--Simple end waypoint that restarts at path 0 again and sets text on the follower\r\nlocal Path = 0\r\nlocal Point = 6\r\nlocal Wait = 0\r\nlocal GoToPath = 0\r\nobj.makeWaypoint(Path, Point, Wait, -1, true, tostring(GoToPath))\r\nobj.waypointScript(\"obj.set3DText(\\\"Hello! \\\" .. tostring(obj.random(1, 100, true)))\")",

"--Clone a star on click, with 1.0s cooldown\r\nobj.setTimer(\"cooldown\", 1.0, \"\")\r\n\r\nlocal star = obj.tryStore(\"SpecialFX\")\r\n\r\nfunction onClick(type)\r\n\t--0 for mouse, 1 for left hand VR trigger, 2 for right hand VR trigger, 3 for mouse right click, 4 for mouse middle click\r\n\tif obj.timerDone(\"cooldown\") then\r\n    \tobj.cloneObject(star, obj.getX(), obj.getY(), obj.getZ())\r\n    \tobj.resetTimer(\"cooldown\")\r\n    end\r\nend",

"soundFile = \"bing.wav\"\r\ntextLabel = \"My name is Snow Leopard\"\r\n\r\nobj.loadAudio(soundFile)\r\nobj.setAction(\"touchMePlayer\", \"Player\", \"action()\", true, true)\r\n\r\nfunction action()\r\n\r\n\tobj.set3DText(textLabel)\r\n\tobj.playAudio()\r\n\r\nend",

"--Default sun, matches default skybox\r\nobj.setSunAngle(\"26.105,29.609,36.014\")",

"--Midday sun\r\nobj.setSunAngle(\"90\")",

"--Afternoon\r\nobj.setSunAngle(\"54.4\")",

"--Glow from below\r\nobj.setSunAngle(\"-0.9\")",

"--Front illumination\r\nobj.setSunAngle(\"0\")",

"--Change the PainCamera location if currently matching branching points\r\nif obj.firstRun() then\r\n    myBP = \"pointname\"\r\n\tobj.runInterval(-1, 0.1) --Run this every 0.1s\r\n\tpc = obj.tryStore(\"PainCam\")\r\nend\r\n\r\nif obj.getBranchPoint() == myBP then\r\n\r\n    pos = obj.getPos(-1)\r\n    dir = obj.getEuler(-1)\r\n    \r\n    obj.moveStored(pos, pc)\r\n    obj.orientStored(dir, pc)\r\n\r\nend",

"--State-based chat system\r\nif obj.firstRun() then\r\n\tobj.runInterval(-1, 0.1) --Run this every 0.1s\r\n\tlastStg = 0\r\n\tobj.setGlobalInt(\"chatstg\", 1)\r\nend\r\n\r\ncurStg = obj.globalInt(\"chatstg\")\r\n\r\nif lastStg < curStg then\r\n    txtLst = {\"Hello _ Click next to continue\", \"You clicked Next\"}\r\n    showText = txtLst[curStg]\r\n    showText = obj.replace(showText, \"_\", \"[newline]\")\r\n    obj.set3DText(showText)\r\n    obj.set3DTextColor(\"1,1,1,1\")\r\n    lastStg = curStg\r\nend",

"--Simple next button to change chat state (index 1 based)\r\nobj.set3DText(\"Next\")\r\nobj.set3DTextColor(\"0,0,0,1\")\r\n\r\nfunction onClick(type)\r\n\tobj.setGlobalInt(\"chatstg\", 2)\r\n\tobj.setStoredActive(-1, false) --Disable after click\r\nend\r\n"
];